% Generate the PDF of a data set.
function [r, pdf,mu,sigma] = PDFData(x,y,binsize)
% (x,y)   The coordinates of the paths
   N = length(x);
%  The dimension.
   d = 2;
%  Bin the data into bins of length binsize.
%  jumps   The jump sizes in increasing order
   jumps = [];
   for n = 1:N-1
      jumps = [jumps; sqrt( (x(n+1)-x(n))^2 + (y(n+1)-y(n))^2 )];
   end
   sorted = sort(floor(jumps/binsize)+1);
   nbins = sorted(N-1);
   pdf = zeros(nbins,1);
   for k = 1:N-1
      pdf(sorted(k)) = pdf(sorted(k))+1;
   end
   pdf = pdf/sum(pdf)/binsize;
   r = binsize*([1:1:nbins]'-1/2);
   mu = mean(sorted);
   sigma = sqrt(mean(sorted.^2/2));
end 
